


#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>


/////////////////////////////////////////////////////////////////////////////////////////////


int main(int argc, char* argv[])
{
    int ret, callparam = -1;

    if(argc<2)
    {
        printf("SEQdemo: missing call parameter\n");
        getch();
        exit(-1);
    }

    ret = sscanf(argv[1],"%d",&callparam);
    if(ret!=1) 
    {
        printf("SEQdemo: inappropriate call parameter, must be 0..1023\n");
        //This should never happen.
        //The PicoHarp 330 software will always start a sequence with 
        //callparam 0 and increment it at each new call, up to the 
        //maximum of 511, corresponding to the max number of 
        //512 curves in a PHU file.
        getch();
        exit(-1);
    }
        
    if((callparam<0)||(callparam>1023))
    {
        printf("SEQdemo: call parameter out of range, must be 0..1023\n");
        getch();
        exit(-1);
    }

    printf("SEQdemo called with parameter %d\n", callparam);

    //Here you would put your code for e.g. setting a monochromator
    //making use of callparam to e.g. encode the wavelength.
    //The PicoHarp software will always start a sequence with 
    //callparam 0 and increment it at each new call.
    //You could do something like
    //  wavelength = startwavelength + callparam * wavelengthstep
    //and then set your monochromator accordingly.

    //For demo purposes we just waste some time here:
    Sleep(1000); //replace by your own code


    //Finally return a value for recording in the PHU data file. 
    //Just for demo purposes we return callparam + 1000.
    //You can return any positive 32-bit integer, 
    //for instance, following the example above, to indicate a wavelength. 
    //Negative values are reserved for error codes and will cause the 
    // measurement sequence to be aborted.
    return callparam + 1000; 
}

